using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Net;
using System.Security.Cryptography.X509Certificates;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class INTERFACE_CALL_LOGDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public INTERFACE_CALL_LOGDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public INTERFACE_CALL_LOG GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32? REGISTRANT_ID)
		{
			INTERFACE_CALL_LOG objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_INTERFACE_CALL_LOG_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<INTERFACE_CALL_LOG> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<INTERFACE_CALL_LOG> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_INTERFACE_CALL_LOG_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<INTERFACE_CALL_LOG> GetItemsByRegistrant(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_ID)
        {
            List<INTERFACE_CALL_LOG> objReturn = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_INTERFACE_CALL_LOG_getitemsByRegistrant(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, INTERFACE_CALL_LOG objSave)
		{
			Int32? objReturn = objSave.REGISTRANT_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_INTERFACE_CALL_LOG_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.INTERFACE_NAME, objSave.PARAMETERS, ref objReturn, objSave.RETURN_VALUES, objSave.TIME_OF_CALL, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32? REGISTRANT_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_INTERFACE_CALL_LOG_delete(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public string GetLastPdfRunDate()
        {
            string objReturn = string.Empty;
            DateTime? objTemp = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objTemp = dbContext.SP_GetMaxPdfCreatedDate().FirstOrDefault();
                    if (objTemp != null)
                        objReturn = objTemp.Value.ToString();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public INTERFACE_CALL_LOG GetLatestInterfaceCallLog(string registrantId)
        {
            INTERFACE_CALL_LOG log = null;
            int registrantIdAsInt = -1;
            int.TryParse(registrantId, out registrantIdAsInt);

            List<INTERFACE_CALL_LOG> logs = GetItemsByRegistrant(string.Empty, 0, registrantIdAsInt);
            //using (_dbAhobpr = GetDataContext())
            if (logs != null)
            {
                log = (from l in logs
                       orderby l.TIME_OF_CALL descending
                       select l).FirstOrDefault();
            }

            return log;
        }

        public byte[] GetDasPdf(string registrantId)
        {
            byte[] bytes = new byte[0];

            try
            {
                INTERFACE_CALL_LOG logEntry = GetLatestInterfaceCallLog(registrantId);
                if (logEntry != null)
                {
                    String blu = FindBlu(logEntry.RETURN_VALUES);

                    String uri = System.Configuration.ConfigurationManager.AppSettings["DasUri"];
                    uri = uri.Replace("core/AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaires/transform", "core/fs/" + blu);
                    HttpWebRequest webRequest = (HttpWebRequest)WebRequest.Create(new Uri(uri));
                    //Add Certificates
                    X509Certificate certificate = GetCert(System.Configuration.ConfigurationManager.AppSettings["AhobprDasCert"]);
                    if (certificate != null)
                    {
                        webRequest.ClientCertificates.Add(certificate);
                    }

                    WebResponse response = webRequest.GetResponse();
                    var sb = new StringBuilder();
                    String responseString = string.Empty;
                    using (System.IO.StreamReader sr = new System.IO.StreamReader(response.GetResponseStream()))
                    {
                        while (sr.Peek() >= 0)
                        {
                            sb.Append(sr.ReadLine());
                        }
                    }
                    bytes = Encoding.UTF8.GetBytes(sb.ToString());
                }
                else
                {
                    bytes = Encoding.UTF8.GetBytes("No Registrant Entry found in Interface Call Log.");
                }
            }
            catch (Exception ex)
            {
                bytes = Encoding.UTF8.GetBytes("Error: " + ex.Message);
            }

            return bytes;
        }

        private X509Certificate2 GetCert(String subjectName)
        {
            X509Store store = new X509Store(StoreName.My, StoreLocation.LocalMachine);
            store.Open(OpenFlags.ReadOnly);
            X509Certificate2Collection certificateCollection = store.Certificates.Find(X509FindType.FindBySubjectName, subjectName, false);
            if (certificateCollection.Count > 0)
            {
                return certificateCollection[0];
            }
            return null;
        }

        private string FindBlu(string json)
        {
            /*
            {"BinaryLocationUri": "2015067346145e29adb157ed9dc296eac9671350", 
            "ObjectID": "$ObjectID(5582e62c2a0c0a725517d14b)", 
            "ConversationID": "d0432ab8-9be5-457b-880f-948bda3c9997"}*/

            string[] tokens = json.Split('"');
            for (int i = 0; i < tokens.Length; i++)
            {
                if (tokens[i] == "BinaryLocationUri")
                {
                    return tokens[i + 2];
                }
            }
            return string.Empty;
        }

        #endregion
    }
}
